/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.base.Objects;
import com.jolbox.bonecp.BoneCPConfigMBean;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneCPConfig
implements BoneCPConfigMBean,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6090570773474131622L;
    private static final String CONFIG_TOSTRING = "JDBC URL = %s, Username = %s, partitions = %d, max (per partition) = %d, min (per partition) = %d, helper threads = %d, idle max age = %d min, idle test period = %d min";
    private static final Logger logger = LoggerFactory.getLogger(BoneCPConfig.class);
    private int minConnectionsPerPartition;
    private int maxConnectionsPerPartition;
    private int acquireIncrement = 2;
    private int partitionCount = 2;
    private String jdbcUrl;
    private String username;
    private String password;
    private long idleConnectionTestPeriod = 14400000L;
    private long idleMaxAge = 3600000L;
    private String connectionTestStatement;
    private int statementsCacheSize = 0;
    private int statementsCachedPerConnection = 0;
    private int releaseHelperThreads = 3;
    private ConnectionHook connectionHook;
    private String initSQL;
    private boolean closeConnectionWatch;
    private boolean logStatementsEnabled;
    private int acquireRetryDelay = 7000;
    private int acquireRetryAttempts = 5;
    private boolean lazyInit;
    private boolean transactionRecoveryEnabled;
    private String connectionHookClassName;
    private ClassLoader classLoader = this.getClassLoader();
    private String poolName;
    private boolean disableJMX;
    private DataSource datasourceBean;
    private int queryExecuteTimeLimit = 0;
    private int poolAvailabilityThreshold = 20;
    private boolean disableConnectionTracking;
    private Properties driverProperties;
    private long connectionTimeout = Long.MAX_VALUE;

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    @Override
    public int getMinConnectionsPerPartition() {
        return this.minConnectionsPerPartition;
    }

    public void setMinConnectionsPerPartition(int minConnectionsPerPartition) {
        this.minConnectionsPerPartition = minConnectionsPerPartition;
    }

    @Override
    public int getMaxConnectionsPerPartition() {
        return this.maxConnectionsPerPartition;
    }

    public void setMaxConnectionsPerPartition(int maxConnectionsPerPartition) {
        this.maxConnectionsPerPartition = maxConnectionsPerPartition;
    }

    @Override
    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public void setAcquireIncrement(int acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
    }

    @Override
    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public long getIdleConnectionTestPeriod() {
        return this.idleConnectionTestPeriod;
    }

    public void setIdleConnectionTestPeriod(long idleConnectionTestPeriod) {
        this.idleConnectionTestPeriod = 60000L * idleConnectionTestPeriod;
    }

    @Override
    public long getIdleMaxAge() {
        return this.idleMaxAge;
    }

    public void setIdleMaxAge(long idleMaxAge) {
        this.idleMaxAge = 60000L * idleMaxAge;
    }

    @Override
    public String getConnectionTestStatement() {
        return this.connectionTestStatement;
    }

    public void setConnectionTestStatement(String connectionTestStatement) {
        this.connectionTestStatement = connectionTestStatement;
    }

    @Override
    @Deprecated
    public int getPreparedStatementsCacheSize() {
        logger.info("Please use getStatementsCacheSize in place of getPreparedStatementsCacheSize. This method has been deprecated.");
        return this.statementsCacheSize;
    }

    @Deprecated
    public void setPreparedStatementsCacheSize(int preparedStatementsCacheSize) {
        logger.info("Please use setStatementsCacheSize in place of setPreparedStatementsCacheSize. This method has been deprecated.");
        this.statementsCacheSize = preparedStatementsCacheSize;
    }

    public void setStatementsCacheSize(int statementsCacheSize) {
        this.statementsCacheSize = statementsCacheSize;
    }

    @Override
    public int getStatementsCacheSize() {
        return this.statementsCacheSize;
    }

    @Deprecated
    public void setStatementCacheSize(int statementsCacheSize) {
        logger.info("Please use setStatementsCacheSize in place of setStatementCacheSize. This method has been deprecated.");
        this.statementsCacheSize = statementsCacheSize;
    }

    @Deprecated
    public int getStatementCacheSize() {
        logger.info("Please use getStatementsCacheSize in place of getStatementCacheSize. This method has been deprecated.");
        return this.statementsCacheSize;
    }

    @Override
    public int getReleaseHelperThreads() {
        return this.releaseHelperThreads;
    }

    public void setReleaseHelperThreads(int releaseHelperThreads) {
        this.releaseHelperThreads = releaseHelperThreads;
    }

    @Override
    @Deprecated
    public int getStatementsCachedPerConnection() {
        return this.statementsCachedPerConnection;
    }

    @Deprecated
    public void setStatementsCachedPerConnection(int statementsCachedPerConnection) {
        this.statementsCachedPerConnection = statementsCachedPerConnection;
    }

    public void sanitize() {
        if (this.poolAvailabilityThreshold < 0 || this.poolAvailabilityThreshold > 100) {
            this.poolAvailabilityThreshold = 20;
        }
        if (this.maxConnectionsPerPartition < 2) {
            logger.warn("Max Connections < 2. Setting to 50");
            this.maxConnectionsPerPartition = 50;
        }
        if (this.minConnectionsPerPartition < 2) {
            logger.warn("Min Connections < 2. Setting to 10");
            this.minConnectionsPerPartition = 10;
        }
        if (this.minConnectionsPerPartition > this.maxConnectionsPerPartition) {
            logger.warn("Min Connections > max connections");
            this.minConnectionsPerPartition = this.maxConnectionsPerPartition;
        }
        if (this.acquireIncrement <= 0) {
            logger.warn("acquireIncrement <= 0. Setting to 1.");
            this.acquireIncrement = 1;
        }
        if (this.partitionCount < 1) {
            logger.warn("partitions < 1! Setting to 1");
            this.partitionCount = 1;
        }
        if (this.releaseHelperThreads < 0) {
            logger.warn("releaseHelperThreads < 0! Setting to 3");
            this.releaseHelperThreads = 3;
        }
        if (this.statementsCacheSize < 0) {
            logger.warn("preparedStatementsCacheSize < 0! Setting to 0");
            this.statementsCacheSize = 0;
        }
        if (this.acquireRetryDelay <= 0) {
            this.acquireRetryDelay = 1000;
        }
        if (this.jdbcUrl == null || this.jdbcUrl.trim().equals("")) {
            logger.warn("JDBC url was not set in config!");
        }
        if (this.datasourceBean == null && this.driverProperties == null && (this.username == null || this.username.trim().equals(""))) {
            logger.warn("JDBC username was not set in config!");
        }
        if (this.datasourceBean == null && this.driverProperties == null && this.password == null) {
            logger.warn("JDBC password was not set in config!");
        }
        if (this.datasourceBean == null && this.driverProperties != null) {
            if (this.driverProperties.get("user") == null && this.username == null) {
                logger.warn("JDBC username not set in driver properties and not set in pool config either");
            } else if (this.driverProperties.get("user") == null && this.username != null) {
                logger.warn("JDBC username not set in driver properties, copying it from pool config");
                this.driverProperties.setProperty("user", this.username);
            } else if (this.username != null && !this.driverProperties.get("user").equals(this.username)) {
                logger.warn("JDBC username set in driver properties does not match the one set in the pool config.  Overriding it with pool config.");
                this.driverProperties.setProperty("user", this.username);
            }
        }
        if (this.datasourceBean == null && this.driverProperties != null) {
            if (this.driverProperties.get("password") == null && this.password == null) {
                logger.warn("JDBC password not set in driver properties and not set in pool config either");
            } else if (this.driverProperties.get("password") == null && this.password != null) {
                logger.warn("JDBC password not set in driver properties, copying it from pool config");
                this.driverProperties.setProperty("password", this.password);
            } else if (this.password != null && !this.driverProperties.get("password").equals(this.password)) {
                logger.warn("JDBC password set in driver properties does not match the one set in the pool config. Overriding it with pool config.");
                this.driverProperties.setProperty("password", this.password);
            }
            this.username = this.driverProperties.getProperty("user");
            this.password = this.driverProperties.getProperty("password");
        }
        this.username = this.username == null ? "" : this.username.trim();
        this.jdbcUrl = this.jdbcUrl == null ? "" : this.jdbcUrl.trim();
        String string = this.password = this.password == null ? "" : this.password.trim();
        if (this.connectionTestStatement != null) {
            this.connectionTestStatement = this.connectionTestStatement.trim();
        }
    }

    public String toString() {
        return String.format(CONFIG_TOSTRING, this.jdbcUrl, this.username, this.partitionCount, this.maxConnectionsPerPartition, this.minConnectionsPerPartition, this.releaseHelperThreads, this.idleMaxAge / 60000L, this.idleConnectionTestPeriod / 60000L);
    }

    @Override
    public ConnectionHook getConnectionHook() {
        return this.connectionHook;
    }

    public void setConnectionHook(ConnectionHook connectionHook) {
        this.connectionHook = connectionHook;
    }

    @Override
    public String getInitSQL() {
        return this.initSQL;
    }

    public void setInitSQL(String initSQL) {
        this.initSQL = initSQL;
    }

    public boolean isCloseConnectionWatch() {
        return this.closeConnectionWatch;
    }

    public void setCloseConnectionWatch(boolean closeConnectionWatch) {
        this.closeConnectionWatch = closeConnectionWatch;
    }

    public boolean isLogStatementsEnabled() {
        return this.logStatementsEnabled;
    }

    public void setLogStatementsEnabled(boolean logStatementsEnabled) {
        this.logStatementsEnabled = logStatementsEnabled;
    }

    public int getAcquireRetryDelay() {
        return this.acquireRetryDelay;
    }

    public void setAcquireRetryDelay(int acquireRetryDelay) {
        this.acquireRetryDelay = acquireRetryDelay;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public BoneCPConfig clone() throws CloneNotSupportedException {
        Field[] fields;
        BoneCPConfig clone = (BoneCPConfig)super.clone();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                field.set(clone, field.get(this));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BoneCPConfig that = (BoneCPConfig)obj;
        return Objects.equal((Object)this.acquireIncrement, (Object)that.getAcquireIncrement()) && Objects.equal((Object)this.acquireRetryDelay, (Object)that.getAcquireRetryDelay()) && Objects.equal((Object)this.closeConnectionWatch, (Object)that.isCloseConnectionWatch()) && Objects.equal((Object)this.logStatementsEnabled, (Object)that.isLogStatementsEnabled()) && Objects.equal((Object)this.connectionHook, (Object)that.getConnectionHook()) && Objects.equal((Object)this.connectionTestStatement, (Object)that.getConnectionTestStatement()) && Objects.equal((Object)this.idleConnectionTestPeriod, (Object)that.getIdleConnectionTestPeriod()) && Objects.equal((Object)this.idleMaxAge, (Object)that.getIdleMaxAge()) && Objects.equal((Object)this.initSQL, (Object)that.getInitSQL()) && Objects.equal((Object)this.jdbcUrl, (Object)that.getJdbcUrl()) && Objects.equal((Object)this.maxConnectionsPerPartition, (Object)that.getMaxConnectionsPerPartition()) && Objects.equal((Object)this.minConnectionsPerPartition, (Object)that.getMinConnectionsPerPartition()) && Objects.equal((Object)this.partitionCount, (Object)that.getPartitionCount()) && Objects.equal((Object)this.releaseHelperThreads, (Object)that.getReleaseHelperThreads()) && Objects.equal((Object)this.statementsCachedPerConnection, (Object)that.getStatementsCachedPerConnection()) && Objects.equal((Object)this.statementsCacheSize, (Object)that.getStatementsCacheSize()) && Objects.equal((Object)this.username, (Object)that.getUsername()) && Objects.equal((Object)this.password, (Object)that.getPassword()) && Objects.equal((Object)this.lazyInit, (Object)that.isLazyInit()) && Objects.equal((Object)this.transactionRecoveryEnabled, (Object)that.isTransactionRecoveryEnabled()) && Objects.equal((Object)this.acquireRetryAttempts, (Object)that.getAcquireRetryAttempts());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.acquireIncrement, this.acquireRetryDelay, this.closeConnectionWatch, this.logStatementsEnabled, this.connectionHook, this.connectionTestStatement, this.idleConnectionTestPeriod, this.idleMaxAge, this.initSQL, this.jdbcUrl, this.maxConnectionsPerPartition, this.minConnectionsPerPartition, this.partitionCount, this.releaseHelperThreads, this.statementsCachedPerConnection, this.statementsCacheSize, this.username, this.password, this.lazyInit, this.transactionRecoveryEnabled, this.acquireRetryAttempts});
    }

    public boolean isTransactionRecoveryEnabled() {
        return this.transactionRecoveryEnabled;
    }

    public void setTransactionRecoveryEnabled(boolean transactionRecoveryEnabled) {
        this.transactionRecoveryEnabled = transactionRecoveryEnabled;
    }

    public int getAcquireRetryAttempts() {
        return this.acquireRetryAttempts;
    }

    public void setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.acquireRetryAttempts = acquireRetryAttempts;
    }

    public void setConnectionHookClassName(String connectionHookClassName) {
        this.connectionHookClassName = connectionHookClassName;
        if (connectionHookClassName != null) {
            try {
                Object hookClass = this.loadClass(connectionHookClassName).newInstance();
                this.connectionHook = (ConnectionHook)hookClass;
            }
            catch (Exception e) {
                logger.error("Unable to create an instance of the connection hook class (" + connectionHookClassName + ")");
                this.connectionHook = null;
            }
        }
    }

    public String getConnectionHookClassName() {
        return this.connectionHookClassName;
    }

    protected Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(clazz);
        }
        return Class.forName(clazz, true, this.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isDisableJMX() {
        return this.disableJMX;
    }

    public void setDisableJMX(boolean disableJMX) {
        this.disableJMX = disableJMX;
    }

    public DataSource getDatasourceBean() {
        return this.datasourceBean;
    }

    public void setDatasourceBean(DataSource datasourceBean) {
        this.datasourceBean = datasourceBean;
    }

    public BoneCPConfig() {
    }

    public BoneCPConfig(String sectionName) throws Exception {
        this(BoneCPConfig.class.getResourceAsStream("/bonecp-config.xml"), sectionName);
    }

    public BoneCPConfig(InputStream xmlConfigFile, String sectionName) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(xmlConfigFile);
        doc.getDocumentElement().normalize();
        Properties settings = this.parseXML(doc, null);
        if (sectionName != null) {
            settings.putAll((Map<?, ?>)this.parseXML(doc, sectionName));
        }
        this.setProperties(settings);
    }

    public BoneCPConfig(Properties props) throws Exception {
        this.setProperties(props);
    }

    private static String upFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public void setProperties(Properties props) throws Exception {
        for (Field field : BoneCPConfig.class.getDeclaredFields()) {
            String val;
            Method method;
            if (Modifier.isFinal(field.getModifiers())) continue;
            if (field.getType().equals(Integer.TYPE)) {
                method = BoneCPConfig.class.getDeclaredMethod("set" + BoneCPConfig.upFirst(field.getName()), Integer.TYPE);
                val = props.getProperty(field.getName());
                if (val == null) {
                    val = props.getProperty("bonecp." + field.getName());
                }
                if (val != null) {
                    try {
                        method.invoke((Object)this, Integer.parseInt(val));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (field.getType().equals(Long.TYPE)) {
                method = BoneCPConfig.class.getDeclaredMethod("set" + BoneCPConfig.upFirst(field.getName()), Long.TYPE);
                val = props.getProperty(field.getName());
                if (val == null) {
                    val = props.getProperty("bonecp." + field.getName());
                }
                if (val == null) continue;
                try {
                    method.invoke((Object)this, Long.parseLong(val));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (field.getType().equals(String.class)) {
                method = BoneCPConfig.class.getDeclaredMethod("set" + BoneCPConfig.upFirst(field.getName()), String.class);
                val = props.getProperty(field.getName());
                if (val == null) {
                    val = props.getProperty("bonecp." + field.getName());
                }
                if (val == null) continue;
                method.invoke((Object)this, val);
                continue;
            }
            if (!field.getType().equals(Boolean.TYPE)) continue;
            method = BoneCPConfig.class.getDeclaredMethod("set" + BoneCPConfig.upFirst(field.getName()), Boolean.TYPE);
            val = props.getProperty(field.getName());
            if (val == null) {
                val = props.getProperty("bonecp." + field.getName());
            }
            if (val == null) continue;
            method.invoke((Object)this, Boolean.parseBoolean(val));
        }
    }

    private Properties parseXML(Document doc, String sectionName) {
        Node node;
        int found = -1;
        Properties results = new Properties();
        NodeList config = null;
        if (sectionName == null) {
            config = doc.getElementsByTagName("default-config");
            found = 0;
        } else {
            config = doc.getElementsByTagName("named-config");
            if (config != null && config.getLength() > 0) {
                for (int i = 0; i < config.getLength(); ++i) {
                    Node name;
                    NamedNodeMap attributes;
                    Node node2 = config.item(i);
                    if (node2.getNodeType() != 1 || (attributes = node2.getAttributes()) == null || attributes.getLength() <= 0 || !(name = attributes.getNamedItem("name")).getNodeValue().equalsIgnoreCase(sectionName)) continue;
                    found = i;
                    break;
                }
            }
            if (found == -1) {
                config = null;
                logger.warn("Did not find " + sectionName + " section in config file. Reverting to defaults.");
            }
        }
        if (config != null && config.getLength() > 0 && (node = config.item(found)).getNodeType() == 1) {
            Element elementEntry = (Element)node;
            NodeList childNodeList = elementEntry.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Element piece;
                NamedNodeMap attributes;
                Node node_j = childNodeList.item(j);
                if (node_j.getNodeType() != 1 || (attributes = (piece = (Element)node_j).getAttributes()) == null || attributes.getLength() <= 0) continue;
                results.put(attributes.item(0).getNodeValue(), piece.getTextContent());
            }
        }
        return results;
    }

    public int getQueryExecuteTimeLimit() {
        return this.queryExecuteTimeLimit;
    }

    public void setQueryExecuteTimeLimit(int queryExecuteTimeLimit) {
        this.queryExecuteTimeLimit = queryExecuteTimeLimit;
    }

    public int getPoolAvailabilityThreshold() {
        return this.poolAvailabilityThreshold;
    }

    public void setPoolAvailabilityThreshold(int poolAvailabilityThreshold) {
        this.poolAvailabilityThreshold = poolAvailabilityThreshold;
    }

    public boolean isDisableConnectionTracking() {
        return this.disableConnectionTracking;
    }

    public void setDisableConnectionTracking(boolean disableConnectionTracking) {
        this.disableConnectionTracking = disableConnectionTracking;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    public void setDriverProperties(Properties driverProperties) {
        if (driverProperties != null) {
            this.driverProperties = new Properties();
            this.driverProperties.putAll((Map<?, ?>)driverProperties);
        }
    }
}

