/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.PoolUtil;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneCPDataSource
extends BoneCPConfig
implements DataSource {
    private static final long serialVersionUID = -1561804548443209469L;
    private PrintWriter logWriter = null;
    private volatile transient BoneCP pool = null;
    private ReadWriteLock rwl = new ReentrantReadWriteLock();
    private String driverClass;
    private static final Logger logger = LoggerFactory.getLogger(BoneCPDataSource.class);

    public BoneCPDataSource() {
    }

    public BoneCPDataSource(BoneCPConfig config) {
        Field[] fields;
        for (Field field : fields = BoneCPConfig.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                field.set(this, field.get(config));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.pool == null) {
            this.maybeInit();
        }
        return this.pool.getConnection();
    }

    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    private void maybeInit() throws SQLException {
        this.rwl.readLock().lock();
        if (this.pool == null) {
            this.rwl.readLock().unlock();
            this.rwl.writeLock().lock();
            if (this.pool == null) {
                try {
                    if (this.getDriverClass() != null) {
                        this.loadClass(this.getDriverClass());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new SQLException(PoolUtil.stringifyException(e));
                }
                logger.debug(this.toString());
                this.pool = new BoneCP(this);
            }
            this.rwl.writeLock().unlock();
        } else {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("getConnectionString username, String password) is not supported");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("getLoginTimeout is unsupported.");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout is unsupported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    public Object unwrap(Class arg0) throws SQLException {
        return null;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public int getTotalLeased() {
        return this.pool.getTotalLeased();
    }

    public BoneCPConfig getConfig() {
        return this;
    }
}

