/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    private boolean daemon;
    private String threadName;
    private static Logger logger = LoggerFactory.getLogger(CustomThreadFactory.class);

    public CustomThreadFactory(String threadName, boolean daemon) {
        this.threadName = threadName;
        this.daemon = daemon;
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(this.daemon);
        t.setName(this.threadName);
        t.setUncaughtExceptionHandler(this);
        return t;
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        logger.error("Uncaught Exception in thread " + thread.getName(), throwable);
    }
}

