/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.collect.MapMaker;
import com.jolbox.bonecp.IStatementCache;
import com.jolbox.bonecp.StatementHandle;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementCache
implements IStatementCache {
    private static Logger logger = LoggerFactory.getLogger(StatementCache.class);
    private ConcurrentMap<String, StatementHandle> cache = new MapMaker().concurrencyLevel(32).makeMap();
    private int cacheSize;

    public StatementCache(int size) {
        this.cacheSize = size;
    }

    public String calculateCacheKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        StringBuffer tmp = this.calculateCacheKeyInternal(sql, resultSetType, resultSetConcurrency);
        tmp.append(", H:");
        tmp.append(resultSetHoldability);
        return tmp.toString();
    }

    public String calculateCacheKey(String sql, int resultSetType, int resultSetConcurrency) {
        StringBuffer tmp = this.calculateCacheKeyInternal(sql, resultSetType, resultSetConcurrency);
        return tmp.toString();
    }

    private StringBuffer calculateCacheKeyInternal(String sql, int resultSetType, int resultSetConcurrency) {
        StringBuffer tmp = new StringBuffer(sql.length() + 20);
        tmp.append(sql);
        tmp.append(", T");
        tmp.append(resultSetType);
        tmp.append(", C");
        tmp.append(resultSetConcurrency);
        return tmp;
    }

    public String calculateCacheKey(String sql, int autoGeneratedKeys) {
        StringBuffer tmp = new StringBuffer(sql.length() + 4);
        tmp.append(sql);
        tmp.append(autoGeneratedKeys);
        return tmp.toString();
    }

    public String calculateCacheKey(String sql, int[] columnIndexes) {
        StringBuffer tmp = new StringBuffer(sql.length() + 4);
        tmp.append(sql);
        for (int i = 0; i < columnIndexes.length; ++i) {
            tmp.append(columnIndexes[i]);
            tmp.append("CI,");
        }
        return tmp.toString();
    }

    public String calculateCacheKey(String sql, String[] columnNames) {
        StringBuffer tmp = new StringBuffer(sql.length() + 4);
        tmp.append(sql);
        for (int i = 0; i < columnNames.length; ++i) {
            tmp.append(columnNames[i]);
            tmp.append("CN,");
        }
        return tmp.toString();
    }

    public StatementHandle get(String key) {
        StatementHandle statement = (StatementHandle)this.cache.get(key);
        if (statement != null && !statement.logicallyClosed.compareAndSet(true, false)) {
            statement = null;
        }
        return statement;
    }

    public StatementHandle get(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return this.get(this.calculateCacheKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public StatementHandle get(String sql, int resultSetType, int resultSetConcurrency) {
        return this.get(this.calculateCacheKey(sql, resultSetType, resultSetConcurrency));
    }

    public StatementHandle get(String sql, int autoGeneratedKeys) {
        return this.get(this.calculateCacheKey(sql, autoGeneratedKeys));
    }

    public StatementHandle get(String sql, int[] columnIndexes) {
        return this.get(this.calculateCacheKey(sql, columnIndexes));
    }

    public StatementHandle get(String sql, String[] columnNames) {
        return this.get(this.calculateCacheKey(sql, columnNames));
    }

    public void put(String key, StatementHandle handle) {
        if (this.cache.size() <= this.cacheSize && key != null && this.cache.putIfAbsent(key, handle) == null) {
            handle.inCache = true;
        }
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        for (StatementHandle statement : this.cache.values()) {
            try {
                statement.internalClose();
            }
            catch (SQLException e) {
                logger.error("Error closing off statement", (Throwable)e);
            }
        }
        this.cache.clear();
    }

    public void checkForProperClosure() {
        for (StatementHandle statement : this.cache.values()) {
            if (statement.isClosed()) continue;
            logger.error("Statement not closed properly in application\n\n" + statement.getOpenStackTrace());
        }
    }
}

