/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.IStatementCache;
import com.jolbox.bonecp.PoolUtil;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementHandle
implements Statement {
    protected Map<Object, Object> logParams = new TreeMap<Object, Object>();
    protected AtomicBoolean logicallyClosed = new AtomicBoolean(false);
    protected Statement internalStatement;
    protected String sql;
    protected IStatementCache cache;
    protected ConnectionHandle connectionHandle;
    private String cacheKey;
    protected boolean logStatementsEnabled;
    protected StringBuffer batchSQL = new StringBuffer();
    public volatile boolean inCache = false;
    public String openStackTrace;
    private static final Logger logger = LoggerFactory.getLogger(StatementHandle.class);
    protected long queryExecuteTimeLimit;
    private ConnectionHook connectionHook;

    public StatementHandle(Statement internalStatement, String sql, IStatementCache cache, ConnectionHandle connectionHandle, String cacheKey, boolean logStatementsEnabled) {
        this.sql = sql;
        this.internalStatement = internalStatement;
        this.cache = cache;
        this.cacheKey = cacheKey;
        this.connectionHandle = connectionHandle;
        this.logStatementsEnabled = logStatementsEnabled;
        try {
            BoneCPConfig config = connectionHandle.getPool().getConfig();
            this.connectionHook = config.getConnectionHook();
            this.queryExecuteTimeLimit = TimeUnit.NANOSECONDS.convert(config.getQueryExecuteTimeLimit(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.connectionHook = null;
            this.queryExecuteTimeLimit = 0L;
        }
        if (this.cache != null) {
            this.cache.put(this.cacheKey, this);
        }
    }

    public StatementHandle(Statement internalStatement, ConnectionHandle connectionHandle, boolean logStatementsEnabled) {
        this(internalStatement, null, null, connectionHandle, null, logStatementsEnabled);
    }

    @Override
    public void close() throws SQLException {
        this.logicallyClosed.set(true);
        if (this.logStatementsEnabled) {
            this.logParams.clear();
        }
        if (this.cache == null || !this.inCache) {
            this.internalClose();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                this.batchSQL.append(sql);
            }
            this.internalStatement.addBatch(sql);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.logicallyClosed.get()) {
            throw new SQLException("Statement is closed");
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.cancel();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                this.batchSQL = new StringBuffer();
            }
            this.internalStatement.clearBatch();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.clearWarnings();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams));
            }
            long timer = this.queryTimerStart();
            result = this.internalStatement.execute(sql);
            this.queryTimerEnd(sql, timer);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    protected void queryTimerEnd(String sql, long queryStartTime) {
        if (System.nanoTime() - queryStartTime > this.queryExecuteTimeLimit && this.connectionHook != null) {
            this.connectionHook.onQueryExecuteTimeLimitExceeded(sql, this.logParams);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.execute(sql, autoGeneratedKeys);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    protected long queryTimerStart() {
        return this.queryExecuteTimeLimit != 0L ? System.nanoTime() : Long.MAX_VALUE;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.execute(sql, columnIndexes);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.execute(sql, columnNames);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] result = null;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(this.batchSQL.toString(), this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.executeBatch();
            this.queryTimerEnd(this.batchSQL.toString(), queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result = null;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.executeQuery(sql);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.executeUpdate(sql);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.executeUpdate(sql, autoGeneratedKeys);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams), (Object)columnIndexes);
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.executeUpdate(sql, columnIndexes);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(sql, this.logParams), (Object[])columnNames);
            }
            long queryStartTime = this.queryTimerStart();
            result = this.internalStatement.executeUpdate(sql, columnNames);
            this.queryTimerEnd(sql, queryStartTime);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connectionHandle;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getFetchDirection();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getFetchSize() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getFetchSize();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet result = null;
        this.checkClosed();
        try {
            result = this.internalStatement.getGeneratedKeys();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getMaxFieldSize();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getMaxRows() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getMaxRows();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.internalStatement.getMoreResults();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.internalStatement.getMoreResults(current);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getQueryTimeout();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet result = null;
        this.checkClosed();
        try {
            result = this.internalStatement.getResultSet();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getResultSetConcurrency();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getResultSetHoldability();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getResultSetType() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getResultSetType();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.internalStatement.getUpdateCount();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning result = null;
        this.checkClosed();
        try {
            result = this.internalStatement.getWarnings();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.logicallyClosed.get();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setPoolable(poolable);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean result = false;
        try {
            result = this.internalStatement.isWrapperFor(iface);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T result = null;
        try {
            result = this.internalStatement.unwrap(iface);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.internalStatement.isPoolable();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
        return result;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setCursorName(name);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setEscapeProcessing(enable);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setFetchDirection(direction);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setFetchSize(rows);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setMaxFieldSize(max);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setMaxRows(max);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        try {
            this.internalStatement.setQueryTimeout(seconds);
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    protected void internalClose() throws SQLException {
        this.batchSQL = new StringBuffer();
        if (this.logStatementsEnabled) {
            this.logParams.clear();
        }
        this.internalStatement.close();
    }

    protected void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    protected void setLogicallyOpen() {
        this.logicallyClosed.set(false);
    }

    public String toString() {
        return this.sql;
    }

    public String getOpenStackTrace() {
        return this.openStackTrace;
    }

    public void setOpenStackTrace(String openStackTrace) {
        this.openStackTrace = openStackTrace;
    }

    public Statement getInternalStatement() {
        return this.internalStatement;
    }

    public void setInternalStatement(Statement internalStatement) {
        this.internalStatement = internalStatement;
    }
}

