/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.bootstrap;

import org.jconfig.bootstrap.BootstrapLoader;
import org.jconfig.bootstrap.DefaultBootstrapLoader;
import org.jconfig.error.ErrorReporter;
import org.jconfig.utils.ConfigurationUtils;

public class BootstrapLoaderFactory {
    public static BootstrapLoader getLoader() {
        String val = ConfigurationUtils.getConfigProperty("jconfig.bootstraploader");
        if (val == null) {
            return new DefaultBootstrapLoader();
        }
        try {
            BootstrapLoader bl = (BootstrapLoader)Class.forName(val).newInstance();
            return bl;
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("Exception while trying to set the bootstrap loader:" + val, e);
            return new DefaultBootstrapLoader();
        }
    }
}

