/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.DefaultCategory;
import org.jconfig.ExtensibleConfiguration;
import org.jconfig.VariableManager;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.AbstractHandler;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.utils.ResourceLocator;

public class SimpleScriptHandler
extends AbstractHandler {
    private String fileName;

    public Configuration load(String configurationName) throws ConfigurationManagerException {
        this.fileName = configurationName + "_config.script";
        try {
            ResourceLocator locator = new ResourceLocator(this.fileName);
            InputStream is = locator.findResource(this.fileName);
            return this.load(configurationName, is);
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("Error while trying to read file", e);
            throw new ConfigurationManagerException("Error while trying to read file");
        }
    }

    public Configuration load(String configurationName, String fileName) throws ConfigurationManagerException {
        try {
            FileInputStream is = new FileInputStream(fileName);
            return this.load(configurationName, is);
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("Error while trying to read file", e);
            throw new ConfigurationManagerException("Error while trying to read file");
        }
    }

    public Configuration load(String configurationName, InputStream is) throws ConfigurationManagerException {
        try {
            String line;
            BufferedReader nis = new BufferedReader(new InputStreamReader(is));
            Vector<String> content = new Vector<String>();
            while ((line = nis.readLine()) != null) {
                content.add(line);
            }
            nis.close();
            boolean addVar = false;
            ExtensibleConfiguration cfg = new ExtensibleConfiguration(configurationName);
            String currentCategoryName = null;
            for (int i = 0; i < content.size(); ++i) {
                String tmp = (String)content.get(i);
                if (tmp == null || tmp.length() <= 0 || tmp.startsWith("#")) continue;
                if (tmp.startsWith(" ") || tmp.startsWith("\t")) {
                    if (tmp.indexOf(":") == -1) continue;
                    String left = tmp.substring(0, tmp.indexOf(":"));
                    left = left.trim();
                    String right = tmp.substring(tmp.indexOf(":") + 1);
                    right = right.trim();
                    if (addVar) {
                        cfg.setVariable(left, right);
                        continue;
                    }
                    cfg.setProperty(left, right, currentCategoryName);
                    continue;
                }
                String name = tmp;
                if ((name = name.trim()).endsWith(":")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (name.equalsIgnoreCase("variables")) {
                    addVar = true;
                    continue;
                }
                addVar = false;
                String extend = null;
                if (name.startsWith("extends")) {
                    int pos = name.indexOf(":");
                    if (pos == -1) continue;
                    cfg.setBaseConfiguration(name.substring(pos + 1).trim());
                    continue;
                }
                if (tmp.indexOf(" extends ") != -1) {
                    extend = name.substring(name.indexOf(" extends ") + 9);
                    extend = extend.trim();
                    name = name.substring(0, name.indexOf(" extends "));
                }
                DefaultCategory ec = new DefaultCategory(name);
                if (extend != null) {
                    ec.setExtendsCategory(extend);
                }
                cfg.setCategory(ec);
                currentCategoryName = name;
            }
            return cfg;
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("Error while trying to read file", e);
            throw new ConfigurationManagerException("Error while trying to read file");
        }
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        StringBuffer buffer = new StringBuffer();
        if (configuration.getBaseConfiguration() != null) {
            buffer.append("extends : ");
            buffer.append(configuration.getBaseConfiguration());
            buffer.append("\n\n");
        }
        VariableManager vm = VariableManager.getInstance();
        Iterator it = vm.getVariables(configuration.getConfigName()).keySet().iterator();
        boolean vars = false;
        if (it.hasNext()) {
            buffer.append("variables:\n");
            vars = true;
        }
        while (it.hasNext()) {
            String varName = (String)it.next();
            String varText = (String)vm.getVariables(configuration.getConfigName()).get(varName);
            buffer.append("\t");
            buffer.append(varName);
            buffer.append(" : ");
            buffer.append(varText);
            buffer.append("\n");
        }
        if (vars) {
            buffer.append("\n");
        }
        String[] cats = configuration.getCategoryNames();
        for (int i = 0; i < cats.length; ++i) {
            buffer.append(cats[i]);
            buffer.append(": \n");
            SortedMap sm = this.getSortedProperties(cats[i], configuration);
            if (sm == null) continue;
            Iterator nit = sm.keySet().iterator();
            while (nit.hasNext()) {
                String name = (String)nit.next();
                String value = (String)sm.get(name);
                buffer.append("\t");
                buffer.append(name);
                buffer.append(" : ");
                buffer.append(value);
                buffer.append("\n");
            }
            buffer.append("\n");
        }
        try {
            FileWriter writer = new FileWriter(this.getFile());
            writer.write(buffer.toString());
            writer.close();
        }
        catch (Exception e) {
            throw new ConfigurationManagerException("Error while saving script:" + e.getMessage());
        }
    }

    protected SortedMap getSortedProperties(String categoryName, Configuration configuration) {
        Properties props = configuration.getProperties(categoryName);
        TreeMap<String, String> sm = new TreeMap<String, String>();
        if (props != null) {
            Iterator<Object> nit = props.keySet().iterator();
            while (nit.hasNext()) {
                String name = (String)nit.next();
                String value = props.getProperty(name);
                sm.put(name, value);
            }
            return sm;
        }
        return null;
    }

    public File getFile() {
        try {
            return new ResourceLocator(this.fileName).getFile();
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("File not found", e);
            return null;
        }
    }

    public Configuration load(String configurationName, ConfigurationParser parser) throws ConfigurationManagerException {
        throw new ConfigurationManagerException("Using a specific parser with this handler is not supported");
    }
}

