/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class Request {
    private InputStream input;
    private String uri;
    private String hostAddress;

    public Request(InputStream input) {
        this.input = input;
    }

    public void parse(Socket socket) {
        int i;
        StringBuffer request = new StringBuffer(2048);
        byte[] buffer = new byte[2048];
        try {
            i = this.input.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            i = -1;
        }
        for (int j = 0; j < i; ++j) {
            request.append((char)buffer[j]);
        }
        this.hostAddress = socket.getInetAddress().getHostAddress();
        this.uri = this.parseUri(request.toString());
    }

    private String parseUri(String requestString) {
        int index2;
        int index1 = requestString.indexOf(32);
        if (index1 != -1 && (index2 = requestString.indexOf(32, index1 + 1)) > index1) {
            return requestString.substring(index1 + 1, index2);
        }
        return null;
    }

    public String getUri() {
        return this.uri;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }
}

