/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.error.ErrorReporter;
import org.jconfig.utils.editors.CharConverter;
import org.jconfig.utils.editors.TypeConverter;

public class CategoryBeanMapper {
    private static HashMap primitives = new HashMap();
    private static HashMap converters;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    private CategoryBeanMapper() {
    }

    public static void mapBean(Object obj, String categoryName, String configName) {
        Configuration cfg = ConfigurationManager.getConfiguration(configName);
        Properties props = cfg.getProperties(categoryName);
        CategoryBeanMapper.mapBean(obj, props);
    }

    public static void mapBean(Object obj, String categoryName) {
        Configuration cfg = ConfigurationManager.getConfiguration();
        Properties props = cfg.getProperties(categoryName);
        CategoryBeanMapper.mapBean(obj, props);
    }

    private static void mapBean(Object obj, Properties fieldMappings) {
        try {
            BeanInfo binfo = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] pds = binfo.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                Class typeClass;
                PropertyDescriptor pd = pds[i];
                String propName = pd.getName();
                String dbValue = (String)fieldMappings.get(propName);
                if (dbValue == null) continue;
                String typeName = pd.getPropertyType().getName();
                Object curObject = null;
                if (converters.containsKey(typeName)) {
                    TypeConverter tc = (TypeConverter)converters.get(typeName);
                    curObject = tc.getObject(dbValue);
                } else if (primitives.containsKey(typeName)) {
                    typeClass = (Class)primitives.get(typeName);
                    curObject = CategoryBeanMapper.getParameter(typeClass, dbValue);
                } else {
                    typeClass = Class.forName(typeName);
                    curObject = CategoryBeanMapper.getParameter(typeClass, dbValue);
                }
                Method setter = pd.getWriteMethod();
                if (setter != null) {
                    if (curObject == null && pd.getPropertyType().isPrimitive()) {
                        throw new IllegalArgumentException("Null property value for primitive property " + propName);
                    }
                    setter.invoke(obj, curObject);
                    continue;
                }
                ErrorReporter.getErrorHandler().reportError("CategoryBeanMapper: No setter method found for:" + propName);
            }
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("CategoryBeanMapper: Exception while trying to configure bean:" + e.getMessage());
        }
    }

    private static Object getParameter(Class clazz, String value) {
        Object obj = null;
        try {
            PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
            if (editor != null) {
                editor.setAsText(value);
                obj = editor.getValue();
            } else {
                Constructor constr = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = CategoryBeanMapper.class$("java.lang.String")) : class$java$lang$String);
                obj = constr.newInstance(value);
            }
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("CategoryBeanMapper: Exception while trying to define parameter:" + e.getMessage());
        }
        return obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitives.put("int", class$java$lang$Integer == null ? (class$java$lang$Integer = CategoryBeanMapper.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitives.put("boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = CategoryBeanMapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitives.put("double", class$java$lang$Double == null ? (class$java$lang$Double = CategoryBeanMapper.class$("java.lang.Double")) : class$java$lang$Double);
        primitives.put("float", class$java$lang$Float == null ? (class$java$lang$Float = CategoryBeanMapper.class$("java.lang.Float")) : class$java$lang$Float);
        primitives.put("long", class$java$lang$Long == null ? (class$java$lang$Long = CategoryBeanMapper.class$("java.lang.Long")) : class$java$lang$Long);
        converters = new HashMap();
        converters.put("char", new CharConverter());
    }
}

