/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.base.FinalizableWeakReference;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.MemorizeTransactionProxy;
import com.jolbox.bonecp.ReleaseHelperThread;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPartition
implements Serializable {
    private static final long serialVersionUID = -7864443421028454573L;
    static Logger logger = LoggerFactory.getLogger(ConnectionPartition.class);
    private ArrayBlockingQueue<ConnectionHandle> freeConnections;
    private final int acquireIncrement;
    private final int minConnections;
    private final int maxConnections;
    protected ReentrantReadWriteLock statsLock = new ReentrantReadWriteLock();
    private int createdConnections = 0;
    private final String url;
    private final String username;
    private final String password;
    private volatile boolean unableToCreateMoreTransactions = false;
    private ArrayBlockingQueue<ConnectionHandle> connectionsPendingRelease;
    private boolean disableTracking;
    private BlockingQueue<Object> poolWatchThreadSignalQueue = new ArrayBlockingQueue<Object>(1);

    protected BlockingQueue<Object> getPoolWatchThreadSignalQueue() {
        return this.poolWatchThreadSignalQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCreatedConnections(int increment) {
        try {
            this.statsLock.writeLock().lock();
            this.createdConnections += increment;
        }
        finally {
            this.statsLock.writeLock().unlock();
        }
    }

    protected void addFreeConnection(ConnectionHandle connectionHandle) throws SQLException {
        connectionHandle.setOriginatingPartition(this);
        if (this.freeConnections.offer(connectionHandle)) {
            this.updateCreatedConnections(1);
            this.trackConnectionFinalizer(connectionHandle);
        } else {
            connectionHandle.internalClose();
        }
    }

    protected void trackConnectionFinalizer(ConnectionHandle connectionHandle) {
        if (!this.disableTracking) {
            Connection con = connectionHandle.getInternalConnection();
            if (con != null && con instanceof Proxy && Proxy.getInvocationHandler(con) instanceof MemorizeTransactionProxy) {
                try {
                    con = (Connection)Proxy.getInvocationHandler(con).invoke(con, ConnectionHandle.class.getMethod("getProxyTarget", new Class[0]), null);
                }
                catch (Throwable t) {
                    logger.error("Error while attempting to track internal db connection", t);
                }
            }
            final Connection internalDBConnection = con;
            final BoneCP pool = connectionHandle.getPool();
            connectionHandle.getPool().getFinalizableRefs().put(con, (Reference<ConnectionHandle>)new FinalizableWeakReference<ConnectionHandle>(connectionHandle, connectionHandle.getPool().getFinalizableRefQueue()){

                public void finalizeReferent() {
                    try {
                        pool.getFinalizableRefs().remove(internalDBConnection);
                        if (internalDBConnection != null && !internalDBConnection.isClosed()) {
                            logger.warn("BoneCP detected an unclosed connection and will now attempt to close it for you. You should be closing this connection in your application - enable connectionWatch for additional debugging assistance.");
                            internalDBConnection.close();
                            ConnectionPartition.this.updateCreatedConnections(-1);
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Error while closing off internal db connection", t);
                    }
                }
            });
        }
    }

    protected ArrayBlockingQueue<ConnectionHandle> getFreeConnections() {
        return this.freeConnections;
    }

    protected void setFreeConnections(ArrayBlockingQueue<ConnectionHandle> freeConnections) {
        this.freeConnections = freeConnections;
    }

    public ConnectionPartition(BoneCP pool) {
        BoneCPConfig config = pool.getConfig();
        this.minConnections = config.getMinConnectionsPerPartition();
        this.maxConnections = config.getMaxConnectionsPerPartition();
        this.acquireIncrement = config.getAcquireIncrement();
        this.url = config.getJdbcUrl();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.connectionsPendingRelease = new ArrayBlockingQueue(this.maxConnections);
        this.disableTracking = config.isDisableConnectionTracking();
        int helperThreads = config.getReleaseHelperThreads();
        if (helperThreads > 0) {
            for (int i = 0; i < helperThreads; ++i) {
                pool.getReleaseHelper().execute(new ReleaseHelperThread(this.connectionsPendingRelease, pool));
            }
        }
    }

    protected int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    protected int getMinConnections() {
        return this.minConnections;
    }

    protected int getMaxConnections() {
        return this.maxConnections;
    }

    protected int getCreatedConnections() {
        this.statsLock.readLock().lock();
        int result = this.createdConnections;
        this.statsLock.readLock().unlock();
        return result;
    }

    protected int getRemainingCapacity() {
        return this.freeConnections.remainingCapacity();
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    protected boolean isUnableToCreateMoreTransactions() {
        return this.unableToCreateMoreTransactions;
    }

    protected void setUnableToCreateMoreTransactions(boolean unableToCreateMoreTransactions) {
        this.unableToCreateMoreTransactions = unableToCreateMoreTransactions;
    }

    protected ArrayBlockingQueue<ConnectionHandle> getConnectionsPendingRelease() {
        return this.connectionsPendingRelease;
    }
}

