/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionPartition;
import java.sql.SQLException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTesterThread
implements Runnable {
    private long idleConnectionTestPeriod;
    private long idleMaxAge;
    private ConnectionPartition partition;
    private ScheduledExecutorService scheduler;
    private BoneCP pool;
    private static Logger logger = LoggerFactory.getLogger(ConnectionTesterThread.class);

    protected ConnectionTesterThread(ConnectionPartition connectionPartition, ScheduledExecutorService scheduler, BoneCP pool, long idleMaxAge, long idleConnectionTestPeriod) {
        this.partition = connectionPartition;
        this.scheduler = scheduler;
        this.idleMaxAge = idleMaxAge;
        this.idleConnectionTestPeriod = idleConnectionTestPeriod;
        this.pool = pool;
    }

    public void run() {
        ConnectionHandle connection = null;
        try {
            long nextCheck = this.idleConnectionTestPeriod;
            int partitionSize = this.partition.getFreeConnections().size();
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < partitionSize; ++i) {
                long tmp;
                connection = this.partition.getFreeConnections().poll();
                if (connection == null) continue;
                connection.setOriginatingPartition(this.partition);
                if (connection.isPossiblyBroken() || this.idleMaxAge > 0L && this.partition.getFreeConnections().size() >= this.partition.getMinConnections() && System.currentTimeMillis() - connection.getConnectionLastUsed() > this.idleMaxAge) {
                    this.closeConnection(connection);
                    continue;
                }
                if (this.idleConnectionTestPeriod > 0L && currentTime - connection.getConnectionLastUsed() > this.idleConnectionTestPeriod && currentTime - connection.getConnectionLastReset() > this.idleConnectionTestPeriod) {
                    if (!this.pool.isConnectionHandleAlive(connection)) {
                        this.closeConnection(connection);
                        continue;
                    }
                    connection.setConnectionLastReset(System.currentTimeMillis());
                    tmp = this.idleConnectionTestPeriod;
                } else {
                    tmp = this.idleConnectionTestPeriod - (System.currentTimeMillis() - connection.getConnectionLastReset());
                }
                if (tmp < nextCheck) {
                    nextCheck = tmp;
                }
                this.pool.putConnectionBackInPartition(connection);
                Thread.sleep(20L);
            }
            this.scheduler.schedule(this, nextCheck, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (this.scheduler.isShutdown()) {
                logger.debug("Shutting down connection tester thread.");
            }
            logger.error("Connection tester thread interrupted", (Throwable)e);
        }
    }

    private void closeConnection(ConnectionHandle connection) {
        if (connection != null) {
            try {
                connection.internalClose();
                this.pool.postDestroyConnection(connection);
            }
            catch (SQLException e) {
                logger.error("Destroy connection exception", (Throwable)e);
            }
        }
    }
}

