/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.IStatementCache;
import com.jolbox.bonecp.PoolUtil;
import com.jolbox.bonecp.StatementHandle;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementHandle
extends StatementHandle
implements PreparedStatement {
    private PreparedStatement internalPreparedStatement;
    private static final Logger logger = LoggerFactory.getLogger(PreparedStatementHandle.class);

    public PreparedStatementHandle(PreparedStatement internalPreparedStatement, String sql, ConnectionHandle connectionHandle, String cacheKey, IStatementCache cache) {
        super(internalPreparedStatement, sql, cache, connectionHandle, cacheKey, connectionHandle.isLogStatementsEnabled());
        this.internalPreparedStatement = internalPreparedStatement;
        this.connectionHandle = connectionHandle;
        this.sql = sql;
        this.cache = cache;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                this.batchSQL.append(this.sql);
            }
            this.internalPreparedStatement.addBatch();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void clearParameters() throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.clearParameters();
            if (this.logStatementsEnabled) {
                this.logParams.clear();
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public boolean execute() throws SQLException {
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(this.sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            boolean result = this.internalPreparedStatement.execute();
            this.queryTimerEnd(this.sql, queryStartTime);
            return result;
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(this.sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            ResultSet result = this.internalPreparedStatement.executeQuery();
            this.queryTimerEnd(this.sql, queryStartTime);
            return result;
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public int executeUpdate() throws SQLException {
        this.checkClosed();
        try {
            if (this.logStatementsEnabled) {
                logger.debug(PoolUtil.fillLogParams(this.sql, this.logParams));
            }
            long queryStartTime = this.queryTimerStart();
            int result = this.internalPreparedStatement.executeUpdate();
            this.queryTimerEnd(this.sql, queryStartTime);
            return result;
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        try {
            return this.internalPreparedStatement.getMetaData();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        try {
            return this.internalPreparedStatement.getParameterMetaData();
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setArray(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBinaryStream(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBinaryStream(parameterIndex, x, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBlob(parameterIndex, inputStream);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, inputStream);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setAsciiStream(parameterIndex, x, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setClob(parameterIndex, reader);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, reader);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setRowId(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setSQLXML(parameterIndex, xmlObject);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, xmlObject);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setClob(parameterIndex, reader, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, reader);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNCharacterStream(parameterIndex, value);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, value);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNCharacterStream(parameterIndex, value, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, value);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNClob(parameterIndex, value);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, value);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNClob(parameterIndex, reader);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, reader);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNClob(parameterIndex, reader, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, reader);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNString(parameterIndex, value);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, value);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setAsciiStream(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setCharacterStream(parameterIndex, reader, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, reader);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBlob(parameterIndex, inputStream, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, inputStream);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setCharacterStream(parameterIndex, reader);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, reader);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setAsciiStream(parameterIndex, x, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBigDecimal(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBinaryStream(parameterIndex, x, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBlob(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBoolean(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setByte(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setBytes(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setCharacterStream(parameterIndex, reader, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, reader);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setClob(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setDate(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setDate(parameterIndex, x, cal);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, PoolUtil.safePrint(x, ", cal=", cal));
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setDouble(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setFloat(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, Float.valueOf(x));
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setInt(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setLong(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNull(parameterIndex, sqlType);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, "[SQL NULL of type " + sqlType + "]");
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setNull(parameterIndex, sqlType, typeName);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, PoolUtil.safePrint("[SQL NULL of type ", sqlType, ", type = ", typeName, "]"));
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setObject(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setObject(parameterIndex, x, targetSqlType);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setRef(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setShort(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setString(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setTime(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setTime(parameterIndex, x, cal);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, PoolUtil.safePrint(x, ", cal=", cal));
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setTimestamp(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setTimestamp(parameterIndex, x, cal);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, PoolUtil.safePrint(x, ", cal=", cal));
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setURL(parameterIndex, x);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        try {
            this.internalPreparedStatement.setUnicodeStream(parameterIndex, x, length);
            if (this.logStatementsEnabled) {
                this.logParams.put(parameterIndex, x);
            }
        }
        catch (Throwable t) {
            throw this.connectionHandle.markPossiblyBroken(t);
        }
    }

    public PreparedStatement getInternalPreparedStatement() {
        return this.internalPreparedStatement;
    }

    public void setInternalPreparedStatement(PreparedStatement internalPreparedStatement) {
        this.internalPreparedStatement = internalPreparedStatement;
    }
}

