/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp.hooks;

import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.PoolUtil;
import com.jolbox.bonecp.hooks.AcquireFailConfig;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionHook
implements ConnectionHook {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionHook.class);

    @Override
    public void onAcquire(ConnectionHandle connection) {
    }

    @Override
    public void onCheckIn(ConnectionHandle connection) {
    }

    @Override
    public void onCheckOut(ConnectionHandle connection) {
    }

    @Override
    public void onDestroy(ConnectionHandle connection) {
    }

    @Override
    public boolean onAcquireFail(Throwable t, AcquireFailConfig acquireConfig) {
        boolean tryAgain = false;
        String log = acquireConfig.getLogMessage();
        logger.error(log + " Sleeping for " + acquireConfig.getAcquireRetryDelay() + "ms and trying again. Attempts left: " + acquireConfig.getAcquireRetryAttempts() + ". Exception: " + t.getCause());
        try {
            Thread.sleep(acquireConfig.getAcquireRetryDelay());
            if (acquireConfig.getAcquireRetryAttempts().get() > 0) {
                tryAgain = acquireConfig.getAcquireRetryAttempts().decrementAndGet() > 0;
            }
        }
        catch (Exception e) {
            tryAgain = false;
        }
        return tryAgain;
    }

    @Override
    public void onQueryExecuteTimeLimitExceeded(String sql, Map<Object, Object> logParams) {
        StringBuilder sb = new StringBuilder("Query execute time limit exceeded. Query: ");
        sb.append(PoolUtil.fillLogParams(sql, logParams));
        logger.warn(sb.toString());
    }

    @Override
    public boolean onConnectionException(ConnectionHandle connection, String state, Throwable t) {
        return true;
    }
}

