/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.util.HashMap;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationFileListener;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.DefaultConfiguration;
import org.jconfig.bootstrap.BootstrapLoader;
import org.jconfig.bootstrap.BootstrapLoaderFactory;
import org.jconfig.bootstrap.LoadedItem;
import org.jconfig.error.ErrorReporter;
import org.jconfig.event.FileListener;
import org.jconfig.handler.AbstractHandler;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.handler.InputStreamHandler;

public class ConfigurationManager {
    private static ConfigurationManager cm = null;
    private static HashMap configurations = null;
    private static HashMap handlerMapping;

    private ConfigurationManager() {
        configurations = new HashMap();
        handlerMapping = new HashMap();
        BootstrapLoader bl = BootstrapLoaderFactory.getLoader();
        try {
            LoadedItem[] configs = bl.load();
            for (int i = 0; i < configs.length; ++i) {
                LoadedItem li = configs[i];
                Configuration config = li.getConfig();
                ConfigurationHandler handler = li.getHandler();
                String name = li.getName();
                configurations.put(name, config);
                handlerMapping.put(name, handler);
            }
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("Exception while trying to load configuratins at startup:", e);
        }
    }

    public static synchronized ConfigurationManager getInstance() {
        if (cm == null) {
            cm = new ConfigurationManager();
        }
        return cm;
    }

    public static Configuration getConfiguration() {
        return ConfigurationManager.getConfiguration("default");
    }

    public static Configuration getConfiguration(String name) {
        ConfigurationManager.getInstance();
        if (name == null) {
            return new DefaultConfiguration(name);
        }
        if (configurations.containsKey(name)) {
            return (Configuration)configurations.get(name);
        }
        String fileName = "config.xml";
        if (!name.equals("default")) {
            fileName = name + "_config.xml";
        }
        InputStreamHandler ish = new InputStreamHandler(fileName);
        try {
            Configuration config = ish.load(name);
            if (config != null) {
                configurations.put(name, config);
                handlerMapping.put(name, ish);
                ConfigurationManager.getInstance().addFileListener(name, new ConfigurationFileListener(name));
            }
            return config;
        }
        catch (ConfigurationManagerException e) {
            ErrorReporter.getErrorHandler().reportError("Problem while trying to read configuration. Returning new configuration.", e);
            return new DefaultConfiguration(name);
        }
    }

    public void load(ConfigurationHandler configurationHandler, String configurationName) throws ConfigurationManagerException {
        Configuration config = configurationHandler.load(configurationName);
        if (configurationHandler instanceof AbstractHandler) {
            ((AbstractHandler)configurationHandler).addFileListener(new ConfigurationFileListener(configurationName));
        }
        if (config != null) {
            configurations.put(configurationName, config);
            handlerMapping.put(configurationName, configurationHandler);
        }
    }

    public void setConfiguration(Configuration configuration, ConfigurationHandler handler) throws ConfigurationManagerException {
        if (configuration != null) {
            configurations.put(configuration.getConfigName(), configuration);
            handlerMapping.put(configuration.getConfigName(), handler);
        }
    }

    public void save(String configName) throws ConfigurationManagerException {
        ConfigurationHandler handler = (ConfigurationHandler)handlerMapping.get(configName);
        if (handler == null) {
            throw new ConfigurationManagerException("No handler assigned to this configuration");
        }
        Configuration config = (Configuration)configurations.get(configName);
        if (config == null) {
            throw new ConfigurationManagerException("No configuration found with the given name");
        }
        this.save(handler, config);
    }

    public void addFileListener(String configName, FileListener fl) {
        ConfigurationHandler handler = (ConfigurationHandler)handlerMapping.get(configName);
        if (handler != null) {
            ((AbstractHandler)handler).addFileListener(fl);
        }
    }

    public void save(ConfigurationHandler handler, Configuration config) throws ConfigurationManagerException {
        handler.store(config);
        configurations.put(config.getConfigName(), config);
        handlerMapping.put(config.getConfigName(), handler);
    }

    public void removeConfiguration(String configName) {
        if (configName != null) {
            configurations.remove(configName);
            handlerMapping.remove(configName);
        }
    }

    public void reload(String name) throws ConfigurationManagerException {
        ConfigurationHandler handler;
        Configuration cfg;
        if (configurations.containsKey(name)) {
            cfg = ConfigurationManager.getConfiguration(name);
            handler = this.getConfigurationHandler(name);
            if (handler == null) {
                throw new ConfigurationManagerException("There is no handler associated for this configuration");
            }
        } else {
            throw new ConfigurationManagerException("There is no configuration with this name");
        }
        cfg = handler.load(name);
        configurations.put(name, cfg);
    }

    public ConfigurationHandler getConfigurationHandler(String name) {
        ConfigurationHandler handler = (ConfigurationHandler)handlerMapping.get(name);
        return handler;
    }

    public String[] getConfigurationNames() {
        return configurations.keySet().toArray(new String[configurations.size()]);
    }

    public static String getVersion() {
        String version = "unknown";
        Package[] allPackages = Package.getPackages();
        for (int i = 0; i < allPackages.length; ++i) {
            if (!allPackages[i].getName().equals("org.jconfig")) continue;
            version = allPackages[i].getImplementationVersion();
        }
        return version;
    }
}

