/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jconfig.Category;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.DefaultCategory;
import org.jconfig.VariableManager;
import org.jconfig.event.CategoryChangedEvent;
import org.jconfig.event.CategoryListener;
import org.jconfig.event.ConfigurationChangedEvent;
import org.jconfig.event.ConfigurationChangedEventImpl;
import org.jconfig.event.ConfigurationListener;
import org.jconfig.event.PropertyChangedEvent;
import org.jconfig.event.PropertyListener;
import org.jconfig.utils.IncludeEntry;

public class DefaultConfiguration
implements Serializable,
Configuration {
    private static boolean debug = false;
    protected static final VariableManager vm = VariableManager.getInstance();
    protected String configName;
    protected HashMap categories;
    protected String mainCategory;
    private EventListenerList configurationListenerList = new EventListenerList();
    private boolean created = true;
    private String encoding;
    protected String baseConfigName;
    private boolean dirtyFlag = false;
    private Vector includes = new Vector();
    static /* synthetic */ Class class$org$jconfig$event$ConfigurationListener;

    protected DefaultConfiguration() {
    }

    public DefaultConfiguration(String configName) {
        this.categories = new HashMap();
        this.configName = configName;
        this.setCategory("general", true);
        this.created = true;
    }

    public void setCategory(String name) {
        this.setCategory(name, false);
    }

    public void renameCategory(String newName, String oldName) {
        Category c = this.getCategory(oldName);
        if (this.mainCategory.equals(c.getCategoryName())) {
            this.mainCategory = newName;
        }
        this.categories.remove(oldName);
        c.renameCategory(newName);
        this.categories.put(newName, c);
        this.markDirty();
    }

    public void setCategory(String categoryName, boolean main) {
        if (categoryName != null) {
            if (main) {
                this.mainCategory = categoryName;
            }
            if (!this.categories.containsKey(categoryName)) {
                DefaultCategory category = new DefaultCategory(categoryName);
                category.setConfigurationName(this.configName);
                category.addCategoryListener(new MyCategoryListener());
                this.categories.put(categoryName, category);
                this.markDirty();
                category.fireCategoryChangedEvent(new ConfigurationChangedEventImpl(4, category, null, null, null));
                this.fireConfigurationChangedEvent(new ConfigurationChangedEventImpl(4, category, null, null, null));
            }
        }
    }

    public void setCategory(Category category) {
        if (!this.categories.containsKey(category.getCategoryName())) {
            category.setConfigurationName(this.configName);
            category.addCategoryListener(new MyCategoryListener());
            this.categories.put(category.getCategoryName(), category);
            category.fireCategoryChangedEvent(new ConfigurationChangedEventImpl(4, category, null, null, null));
            this.fireConfigurationChangedEvent(new ConfigurationChangedEventImpl(4, category, null, null, null));
        }
    }

    public String getMainCategoryName() {
        return this.mainCategory;
    }

    public String[] getCategoryNames() {
        return this.getCategoryNames(true);
    }

    protected String[] getCategoryNames(boolean includeParent) {
        Set allCategories = this.categories.keySet();
        Vector all = new Vector(allCategories);
        if (this.baseConfigName != null && includeParent) {
            Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
            String[] parentCategories = cfg.getCategoryNames();
            for (int i = 0; i < parentCategories.length; ++i) {
                if (all.indexOf(parentCategories[i]) != -1) continue;
                all.add(parentCategories[i]);
            }
        }
        return all.toArray(new String[0]);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null, null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key, defaultValue, null);
    }

    public String getProperty(String key, String defaultValue, String categoryName) {
        String tmp;
        Category category;
        if (categoryName == null) {
            categoryName = this.mainCategory;
        }
        boolean isMainCat = false;
        if (key == null) {
            return defaultValue;
        }
        if (!this.categories.containsKey(categoryName)) {
            isMainCat = true;
        }
        if ((category = this.getCategory(categoryName)).getCategoryName().equals(this.mainCategory)) {
            isMainCat = true;
        }
        if ((tmp = category.getProperty(key)) == null && !isMainCat) {
            category = this.getCategory(this.mainCategory);
            tmp = category.getProperty(key);
        }
        if (tmp == null) {
            if (this.baseConfigName != null) {
                Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
                tmp = cfg.getProperty(key, defaultValue, categoryName);
            } else {
                tmp = defaultValue;
            }
        }
        return tmp;
    }

    public void setProperty(String name, String value) {
        this.setProperty(name, value, null);
    }

    public void setProperty(String name, String value, String categoryName) {
        if (name != null) {
            if (categoryName == null) {
                categoryName = this.mainCategory;
            }
            Category category = this.getCategory(categoryName);
            category.setProperty(name, value);
            this.markDirty();
            this.fireConfigurationChangedEvent(new ConfigurationChangedEventImpl(3, category, name, value, null));
        }
    }

    public void removeProperty(String name) {
        if (name != null) {
            this.removeProperty(name, null);
        }
    }

    public void removeProperty(String name, String category) {
        if (category == null) {
            category = this.mainCategory;
        }
        if (name != null) {
            Category cat = this.getCategory(category);
            String tmp = cat.getProperty(name, null);
            cat.setProperty(name, null);
            this.fireConfigurationChangedEvent(new ConfigurationChangedEventImpl(2, cat, name, tmp, null));
            this.markDirty();
        }
    }

    public int getNumberOfCategories() {
        return this.getCategoryNames().length;
    }

    public void removeCategory(String category) {
        if (this.categories.containsKey(category)) {
            Category cat = this.getCategory(category);
            this.categories.remove(category);
            cat.fireCategoryChangedEvent(new ConfigurationChangedEventImpl(5, cat, null, null, null));
            this.fireConfigurationChangedEvent(new ConfigurationChangedEventImpl(5, cat, null, null, null));
            cat = null;
            this.markDirty();
        }
    }

    public Properties getProperties(String category) {
        return this.getProperties(category, true);
    }

    public Properties getProperties() {
        return this.getProperties(this.mainCategory, true);
    }

    protected Properties getProperties(String category, boolean includeParent) {
        this.println("configname = " + this.configName + ", baseConfigname = " + this.baseConfigName + ", category=" + category);
        Category cat = this.getCategory(category);
        Properties props = new Properties();
        if (cat != null) {
            props = (Properties)cat.getProperties().clone();
            this.println("+-+ " + cat.getCategoryName());
            if (debug) {
                props.list(System.err);
            }
            this.println("+-+ " + cat.getCategoryName());
        }
        if (this.baseConfigName != null && includeParent) {
            Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
            Properties parentProps = cfg.getProperties(category);
            this.println("!!!!!");
            if (debug) {
                parentProps.list(System.err);
            }
            this.println("!!!!!");
            Enumeration<Object> num = parentProps.keys();
            while (num.hasMoreElements()) {
                String name = (String)num.nextElement();
                this.println("lookin for " + name);
                if (props.containsKey(name)) continue;
                this.println("adding " + name);
                props.setProperty(name, (String)parentProps.get(name));
            }
        }
        return props;
    }

    private void println(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    public String[] getPropertyNames(String category) {
        Properties properties;
        if (this.containsCategory(category) && (properties = this.getProperties(category)) != null) {
            Enumeration<?> en = properties.propertyNames();
            Vector<String> keys = new Vector<String>();
            while (en.hasMoreElements()) {
                String nm = (String)en.nextElement();
                keys.add(nm);
            }
            return keys.toArray(new String[0]);
        }
        return null;
    }

    public void setVariable(String name, String value) {
        if (name != null && value != null) {
            vm.addVariable(name, value, this.configName);
        }
    }

    public HashMap getVariables() {
        return vm.getVariables(this.configName);
    }

    public String getVariable(String name) {
        return vm.getVariable(this.configName, name);
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.getIntProperty(name, defaultValue, this.mainCategory);
    }

    public int getIntProperty(String name, int defaultValue, String category) {
        String value = this.getProperty(name, null, category);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(vm.replaceVariables(value, this.configName));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getBooleanProperty(name, defaultValue, this.mainCategory);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue, String categoryName) {
        String value = this.getProperty(name, null, categoryName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(vm.replaceVariables(value, this.configName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setBooleanProperty(String key, boolean value) {
        this.getCategory().setBooleanProperty(key, value);
    }

    public void setBooleanProperty(String key, boolean value, String category) {
        this.getCategory(category).setBooleanProperty(key, value);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.getLongProperty(name, defaultValue, this.mainCategory);
    }

    public long getLongProperty(String name, long defaultValue, String categoryName) {
        String value = this.getProperty(name, null, categoryName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(vm.replaceVariables(value, this.configName));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.getDoubleProperty(name, defaultValue, this.mainCategory);
    }

    public double getDoubleProperty(String name, double defaultValue, String category) {
        String value = this.getProperty(name, null, category);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(vm.replaceVariables(value, this.configName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public char getCharProperty(String name, char defaultValue) {
        return this.getCharProperty(name, defaultValue, this.mainCategory);
    }

    public char getCharProperty(String name, char defaultValue, String category) {
        Category cat = this.getCategory(category);
        return cat.getCharProperty(name, defaultValue);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String[] cats = this.getCategoryNames(false);
        for (int i = 0; i < cats.length; ++i) {
            buffer.append("Category=");
            buffer.append(cats[i]);
            Properties props = this.getProperties(cats[i], false);
            if (props == null) continue;
            buffer.append("\n");
            Iterator<Object> nit = props.keySet().iterator();
            while (nit.hasNext()) {
                String name = (String)nit.next();
                String value = props.getProperty(name);
                buffer.append("  ");
                buffer.append(name);
                buffer.append("=");
                buffer.append(value);
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public String getXMLAsString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"");
        if (this.getEncoding() != null) {
            buffer.append(" encoding=\"" + this.getEncoding() + "\"");
        }
        buffer.append(" ?>\n");
        buffer.append("<properties");
        if (this.baseConfigName != null) {
            buffer.append(" extends=\"");
            buffer.append(this.baseConfigName);
            buffer.append("\"");
        }
        buffer.append(">\n");
        this.addIncludeBlock(buffer);
        this.addVariableBlock(buffer);
        String[] cats = this.getCategoryNames(false);
        for (int i = 0; i < cats.length; ++i) {
            buffer.append("  <category name=\"");
            buffer.append(this.escapeForXML(cats[i]));
            buffer.append("\">\n");
            SortedMap sm = this.getSortedProperties(cats[i], false);
            if (sm == null) continue;
            Iterator nit = sm.keySet().iterator();
            while (nit.hasNext()) {
                String name = (String)nit.next();
                String value = (String)sm.get(name);
                buffer.append("    <property name=\"");
                buffer.append(this.escapeForXML(name));
                buffer.append("\" value=\"");
                buffer.append(this.escapeForXML(value));
                buffer.append("\"/>\n");
            }
            buffer.append("  </category>\n");
        }
        buffer.append("</properties>\n");
        return buffer.toString();
    }

    protected SortedMap getSortedProperties(String categoryName, boolean includeParent) {
        Properties props = this.getProperties(categoryName, includeParent);
        TreeMap<String, String> sm = new TreeMap<String, String>();
        if (props != null) {
            Iterator<Object> nit = props.keySet().iterator();
            while (nit.hasNext()) {
                String name = (String)nit.next();
                String value = props.getProperty(name);
                sm.put(name, value);
            }
            return sm;
        }
        return null;
    }

    protected void addIncludeBlock(StringBuffer buffer) {
        if (this.includes.size() > 0) {
            for (int i = 0; i < this.includes.size(); ++i) {
                IncludeEntry ie = (IncludeEntry)this.includes.get(i);
                buffer.append("  <include ");
                if (ie.getType() != 1) continue;
                buffer.append("properties=\"");
                buffer.append(ie.getName());
                buffer.append("\"/>\n");
            }
        }
    }

    protected void addVariableBlock(StringBuffer buffer) {
        Iterator it = vm.getVariables(this.configName).keySet().iterator();
        boolean vars = false;
        if (it.hasNext()) {
            buffer.append("  <variables>\n");
            vars = true;
        }
        while (it.hasNext()) {
            String varName = (String)it.next();
            String varText = (String)vm.getVariables(this.configName).get(varName);
            buffer.append("    <variable name=\"");
            buffer.append(this.escapeForXML(varName));
            buffer.append("\" value=\"");
            buffer.append(this.escapeForXML(varText));
            buffer.append("\"/>\n");
        }
        if (vars) {
            buffer.append("  </variables>\n");
        }
    }

    protected String escapeForXML(String text) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char character = text.charAt(i);
            if (character == '<') {
                result.append("&lt;");
                continue;
            }
            if (character == '>') {
                result.append("&gt;");
                continue;
            }
            if (character == '\"') {
                result.append("&quot;");
                continue;
            }
            if (character == '\'') {
                result.append("&#039;");
                continue;
            }
            if (character == '\\') {
                result.append("&#092;");
                continue;
            }
            if (character == '&') {
                result.append("&amp;");
                continue;
            }
            result.append(character);
        }
        return result.toString();
    }

    public void addPropertyListener(PropertyListener listener) {
        this.addPropertyListener(listener, this.mainCategory);
    }

    public void addPropertyListener(PropertyListener listener, String categoryName) {
        this.getCategory(categoryName).addPropertyListener(listener);
    }

    public void addCategoryListener(CategoryListener listener) {
        this.addCategoryListener(listener, this.mainCategory);
    }

    public void addCategoryListener(CategoryListener listener, String categoryName) {
        this.getCategory(categoryName).addCategoryListener(listener);
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.configurationListenerList.add(class$org$jconfig$event$ConfigurationListener == null ? (class$org$jconfig$event$ConfigurationListener = DefaultConfiguration.class$("org.jconfig.event.ConfigurationListener")) : class$org$jconfig$event$ConfigurationListener, listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.configurationListenerList.remove(class$org$jconfig$event$ConfigurationListener == null ? (class$org$jconfig$event$ConfigurationListener = DefaultConfiguration.class$("org.jconfig.event.ConfigurationListener")) : class$org$jconfig$event$ConfigurationListener, listener);
    }

    public void fireConfigurationChangedEvent(ConfigurationChangedEvent event) {
        Object[] listeners = this.configurationListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$jconfig$event$ConfigurationListener == null ? DefaultConfiguration.class$("org.jconfig.event.ConfigurationListener") : class$org$jconfig$event$ConfigurationListener)) continue;
            ((ConfigurationListener)listeners[i + 1]).configurationChanged(event);
        }
    }

    public Category getCategory() {
        return this.getCategory(this.mainCategory);
    }

    public Category getCategory(String categoryName) {
        Category category;
        if (categoryName == null) {
            categoryName = this.mainCategory;
        }
        if ((category = (Category)this.categories.get(categoryName)) == null) {
            if (this.baseConfigName != null) {
                Configuration cfg = ConfigurationManager.getConfiguration(this.baseConfigName);
                return cfg.getCategory(categoryName);
            }
            category = new DefaultCategory(categoryName);
            this.categories.put(categoryName, category);
        } else if (this.baseConfigName != null && !"base".equals(this.baseConfigName)) {
            Configuration parentCfg = ConfigurationManager.getConfiguration(this.baseConfigName);
            Category parentCategory = parentCfg.getCategory(categoryName);
            Properties props = parentCategory.getProperties();
            Iterator<Object> iter = props.keySet().iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                if (category.getProperty(element) != null) continue;
                category.setProperty(element, parentCategory.getProperty(element));
            }
        }
        return category;
    }

    public void setLongProperty(String key, long value) {
        this.getCategory().setLongProperty(key, value);
    }

    public void setIntProperty(String key, int value) {
        this.getCategory().setIntProperty(key, value);
    }

    public void setCharProperty(String key, char value) {
        this.getCategory().setCharProperty(key, value);
    }

    public void setCharProperty(String key, char value, String category) {
        this.getCategory(category).setCharProperty(key, value);
    }

    public void setDoubleProperty(String key, double value) {
        this.getCategory().setDoubleProperty(key, value);
    }

    public void setLongProperty(String key, long value, String category) {
        this.getCategory(category).setLongProperty(key, value);
    }

    public void setIntProperty(String key, int value, String category) {
        this.getCategory(category).setIntProperty(key, value);
    }

    public void setDoubleProperty(String key, double value, String category) {
        this.getCategory(category).setDoubleProperty(key, value);
    }

    public boolean hasChanged() {
        return this.dirtyFlag;
    }

    public String[] getArray(String key) {
        return this.getArray(key, null);
    }

    public String[] getArray(String key, String[] defaultValue) {
        return this.getArray(key, defaultValue, this.mainCategory);
    }

    public String[] getArray(String key, String[] defaultValue, String category) {
        return this.getArray(key, defaultValue, category, ",");
    }

    public String[] getArray(String key, String[] defaultValue, String category, String separator) {
        String value = this.getProperty(key, null, category);
        if (value == null) {
            return defaultValue;
        }
        Vector<String> all = new Vector<String>();
        StringTokenizer sto = new StringTokenizer(value, separator);
        while (sto.hasMoreElements()) {
            String val = (String)sto.nextElement();
            val = vm.replaceVariables(val, this.configName);
            all.add(val);
        }
        return all.toArray(new String[0]);
    }

    public boolean isNew() {
        return this.created;
    }

    public void resetCreated() {
        this.created = false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void markDirty() {
        this.dirtyFlag = true;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean containsCategory(String categoryName) {
        if (categoryName == null) {
            return false;
        }
        Category category = (Category)this.categories.get(categoryName);
        return category != null;
    }

    public void addInclude(int type, String name) {
        IncludeEntry ie = new IncludeEntry(name, type);
        this.includes.add(ie);
    }

    public Vector getIncludes() {
        return this.includes;
    }

    public void setBaseConfiguration(String name) {
        this.baseConfigName = name;
        VariableManager.getInstance().setInheritance(this.configName, name);
    }

    public String getBaseConfiguration() {
        return this.baseConfigName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MyCategoryListener
    implements CategoryListener {
        protected MyCategoryListener() {
        }

        public void categoryChanged(CategoryChangedEvent event) {
            DefaultConfiguration.this.fireConfigurationChangedEvent((ConfigurationChangedEvent)event);
        }

        public void propertyChanged(PropertyChangedEvent e) {
        }
    }
}

