/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.jconfig.FileWatcherException;
import org.jconfig.event.FileListener;
import org.jconfig.event.FileListenerEvent;

public class URLFileWatcher
extends Thread {
    private List fileListenerList;
    private volatile Thread watcher;
    private int interval;
    private long lastmodified;
    private URL configURL;
    private String url;
    private URLConnection con;

    public URLFileWatcher(String url) throws FileWatcherException {
        block10: {
            this.interval = 10000;
            this.configURL = null;
            this.con = null;
            if (url == null) {
                throw new NullPointerException("URL cannot be <null>");
            }
            this.url = url;
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                InputStream jcf = cl.getResourceAsStream("jconfig.properties");
                if (jcf == null) break block10;
                Properties jcfProperties = new Properties();
                jcfProperties.load(jcf);
                Properties prop = System.getProperties();
                if (jcfProperties.getProperty("http.proxyHost") != null) {
                    prop.put("http.proxyHost", jcfProperties.getProperty("http.proxyHost"));
                }
                if (jcfProperties.getProperty("http.proxyPort") != null) {
                    prop.put("http.proxyPort", jcfProperties.getProperty("http.proxyPort"));
                }
                if (jcfProperties.getProperty("watcher.interval") == null) break block10;
                try {
                    this.setInterval(Integer.parseInt(jcfProperties.getProperty("watcher.interval")));
                }
                catch (NumberFormatException nfe) {
                    throw new FileWatcherException(nfe.getMessage());
                }
            }
            catch (IOException ioe) {
                throw new FileWatcherException(ioe.getMessage());
            }
        }
        try {
            this.configURL = new URL(url);
            this.con = this.configURL.openConnection();
            this.lastmodified = this.con.getLastModified();
            this.fileListenerList = new Vector();
        }
        catch (MalformedURLException m) {
            throw new FileWatcherException(m.getMessage());
        }
        catch (IOException ioe) {
            throw new FileWatcherException(ioe.getMessage());
        }
    }

    public void addFileListener(FileListener fileListener) {
        this.fileListenerList.add(fileListener);
    }

    public void setInterval(int seconds) {
        this.interval = seconds * 1000;
    }

    public void stopWatching() {
        this.watcher = null;
    }

    public void start() {
        this.watcher = new Thread(this);
        this.watcher.setDaemon(true);
        this.watcher.start();
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (thisThread == this.watcher) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                this.watcher = null;
            }
            try {
                this.checkURLFile();
            }
            catch (Exception e) {
                this.watcher = null;
            }
        }
    }

    public FileListener[] getFileListeners() {
        return (FileListener[])this.fileListenerList.toArray();
    }

    public void setURL(String url) throws FileWatcherException {
        if (url == null) {
            throw new NullPointerException("url cannot be <null>");
        }
        this.url = url;
        try {
            this.configURL = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new FileWatcherException(e.getMessage());
        }
    }

    public String getURLString() {
        return this.url;
    }

    public URL getURL() {
        return this.configURL;
    }

    public void setURL(URL configURL) {
        if (configURL == null) {
            throw new NullPointerException("URL cannot be <null>");
        }
        this.configURL = configURL;
    }

    private void checkURLFile() throws FileWatcherException {
        try {
            URL u = this.configURL;
            URLConnection uConn = u.openConnection();
            long mod = uConn.getLastModified();
            if (mod > this.lastmodified) {
                this.lastmodified = mod;
                Iterator iterator = this.fileListenerList.iterator();
                while (iterator.hasNext()) {
                    FileListener listener = (FileListener)iterator.next();
                    listener.fileChanged(new FileListenerEvent(null));
                }
            }
        }
        catch (IOException ioe) {
            throw new FileWatcherException(ioe.getMessage());
        }
    }
}

