/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.BaseXMLHandler;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.parser.ConfigurationParserFactory;
import org.jconfig.utils.ConfigErrorHandler;
import org.jconfig.utils.ResourceLocator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class InputStreamHandler
extends BaseXMLHandler
implements ConfigurationHandler {
    private boolean validate = false;
    private String filename;

    public InputStreamHandler() {
    }

    public InputStreamHandler(String filename) {
        this.filename = filename;
    }

    public void setFileName(String fileName) {
        this.filename = fileName;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public synchronized Configuration load(String configurationName) throws ConfigurationManagerException {
        ConfigurationParser parser = ConfigurationParserFactory.getParser(configurationName);
        return this.load(configurationName, parser);
    }

    public Configuration load(String configurationName, ConfigurationParser parser) throws ConfigurationManagerException {
        InputStream is = null;
        try {
            is = new ResourceLocator(this.filename).getInputStream();
            if (is == null) {
                ErrorReporter.getErrorHandler().reportError("File not found:" + this.filename);
                is = new ResourceLocator("config.xml").getInputStream();
            }
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("Cannot load file:" + this.filename, e);
            throw new ConfigurationManagerException(e.getLocalizedMessage());
        }
        if (is != null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(this.validate);
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                ErrorReporter.getErrorHandler().reportError("The parser cannot create a new document builder", pce);
                throw new ConfigurationManagerException("The parser cannot create a new document builder: " + pce.getMessage());
            }
            if (this.validate) {
                try {
                    OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
                    db.setErrorHandler(new ConfigErrorHandler(new PrintWriter((Writer)errorWriter, true)));
                }
                catch (Exception e) {
                    ErrorReporter.getErrorHandler().reportError("The parser cannot set up the error handler", e);
                    throw new ConfigurationManagerException("The parser cannot set up the error handler");
                }
            }
            Document doc = null;
            try {
                doc = db.parse(is);
            }
            catch (SAXException se) {
                ErrorReporter.getErrorHandler().reportError("The parser cannot parse the file", se);
                throw new ConfigurationManagerException("The parser cannot parse the file: " + se.getMessage());
            }
            catch (IOException ioe) {
                ErrorReporter.getErrorHandler().reportError("The parser cannot open the file", ioe);
                throw new ConfigurationManagerException("The parser cannot open the file: " + ioe.getMessage());
            }
            Configuration config = parser.parse(doc, configurationName);
            config.resetCreated();
            return config;
        }
        ErrorReporter.getErrorHandler().reportError("The file:" + this.filename + " not found in classpath");
        throw new ConfigurationManagerException("The file could not be found in the classpath");
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        try {
            this.store(new ResourceLocator(this.filename).getFile(), configuration);
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("File " + this.filename + " could not be found", e);
            throw new ConfigurationManagerException("File " + this.filename + " could not be found");
        }
    }

    public File getFile() {
        try {
            return new ResourceLocator(this.filename).getFile();
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("File not found", e);
            return null;
        }
    }
}

