/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.jmx;

import java.io.File;
import java.net.URL;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.handler.XMLFileHandler;
import org.jconfig.jmx.ConfigHandlerMBean;

public class ConfigHandler
implements ConfigHandlerMBean {
    private String resourceName;
    private String configName;

    public String getConfigurationName() {
        return this.configName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setConfigurationName(String configName) {
        if (this.resourceName != null) {
            this.load(this.resourceName, configName);
        }
        this.configName = configName;
    }

    public void setResourceName(String resourceName) {
        if (this.configName != null) {
            this.load(resourceName, this.configName);
        }
        this.resourceName = resourceName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ConfigHandler:\n");
        buffer.append("Resourcename:");
        buffer.append(this.resourceName);
        buffer.append("\nConfigname:");
        buffer.append(this.configName);
        return buffer.toString();
    }

    public void forceReload() {
        this.load(this.resourceName, this.configName);
    }

    public String getName() {
        return "jConfig:" + this.configName;
    }

    private void load(String resourceName, String configName) {
        try {
            if (configName == null) {
                configName = "default";
            }
            ConfigurationManager myConfig = ConfigurationManager.getInstance();
            URL url = null;
            if (resourceName.indexOf("://") >= 0) {
                url = new URL(resourceName);
            } else {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                url = cl.getResource(resourceName);
            }
            if (url != null) {
                File file = new File(url.getFile());
                XMLFileHandler handler = new XMLFileHandler(file.getAbsolutePath());
                myConfig.load(handler, configName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String showConfiguration() {
        Configuration myConfig = ConfigurationManager.getConfiguration(this.configName);
        if (myConfig != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<pre>");
            buffer.append(((Object)myConfig).toString());
            buffer.append("</pre>");
            return buffer.toString();
        }
        return null;
    }

    public void removeProperty(String name, String category) {
        Configuration config = ConfigurationManager.getConfiguration(this.configName);
        config.removeProperty(name, category);
    }

    public void saveConfiguration() throws Exception {
        ConfigurationManager.getInstance().save(this.configName);
    }

    public void setProperty(String name, String value, String category) {
        Configuration config = ConfigurationManager.getConfiguration(this.configName);
        config.setProperty(name, value, category);
    }
}

