/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.jmx;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jconfig.ConfigurationManager;
import org.jconfig.jmx.AbstractDynamicMBean;
import org.jconfig.jmx.ConfigurationDynamicMBean;

public class ConfigurationManagerDynamicMBean
extends AbstractDynamicMBean
implements DynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private NotificationBroadcasterSupport nbs = new NotificationBroadcasterSupport();
    private ArrayList alAttributes = new ArrayList();
    private String dClassName = this.getClass().getName();
    private String dDescription = "This MBean acts as a management facade for ConfigurationManager";
    private ObjectName objectName;

    public ConfigurationManagerDynamicMBean() {
        try {
            this.objectName = new ObjectName("user:configuration=DynamicConfiguration");
            this.buildDynamicMBeanInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildDynamicMBeanInfo() {
        System.out.println("----------------------------------------------------- buildDynamicMBeanInfo()");
        Constructor<?>[] constructors = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("HierarchyDynamicMBean(): Constructs a ConfigurationManagerDynamicMBean instance", constructors[0]);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", "Create a Configuration")};
        this.dOperations[0] = new MBeanOperationInfo("loadConfiguration", "loadConfiguration(): loads a Configuration", params, "javax.management.ObjectName", 1);
        String[] names = ConfigurationManager.getInstance().getConfigurationNames();
        System.out.println("----------------------------------------------------- buildDynamicMBeanInfo loading all configs");
        for (int i = 0; i < names.length; ++i) {
            System.out.println("----------------------------------------------------- buildDynamicMBeanInfo config:" + names[i]);
            this.loadConfiguration(names[i]);
        }
    }

    public void setName(String name) {
        this.loadConfiguration(name);
    }

    public String getName() {
        return "my name";
    }

    public ObjectName loadConfiguration(String name) {
        System.out.println("loadConfiguration called:" + name);
        for (int i = 0; i < this.alAttributes.size(); ++i) {
            MBeanAttributeInfo mai = (MBeanAttributeInfo)this.alAttributes.get(i);
            if (!mai.getName().equalsIgnoreCase("configuration=" + name)) continue;
            return null;
        }
        return this.registerConfigurationMBean(name);
    }

    ObjectName registerConfigurationMBean(String name) {
        ObjectName configurationObjectName = null;
        try {
            configurationObjectName = new ObjectName(this.objectName.getDomain(), "configuration", name);
            ConfigurationDynamicMBean configurationMBean = new ConfigurationDynamicMBean(configurationObjectName, name);
            this.server.registerMBean(configurationMBean, configurationObjectName);
            this.alAttributes.add(new MBeanAttributeInfo("configuration=" + name, "javax.management.ObjectName", "The " + name + " configuration.", true, true, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.objectName;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attribs = new MBeanAttributeInfo[this.alAttributes.size()];
        this.alAttributes.toArray(attribs);
        return new MBeanInfo(this.dClassName, this.dDescription, attribs, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.nbs.getNotificationInfo();
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("loadConfiguration")) {
            return this.loadConfiguration((String)params[0]);
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attributeName.startsWith("configuration")) {
            try {
                return new ObjectName(this.objectName.getDomain() + ":" + attributeName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new AttributeNotFoundException("Cannot find " + attributeName + " attribute in " + this.dClassName);
    }

    public void postRegister(Boolean registrationDone) {
        ConfigurationManager configMngr = ConfigurationManager.getInstance();
        String[] configNames = configMngr.getConfigurationNames();
        for (int i = 0; i < configNames.length; ++i) {
            this.registerConfigurationMBean(configNames[i]);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        System.out.println("-------------------------------------------set:" + name + " value:" + value);
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
    }
}

